% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9ExpandRangeMajor}
\alias{\%i9mj\%}
\alias{icd9ExpandRangeMajor}
\title{create range of icd9 major parts}
\usage{
icd9ExpandRangeMajor(start, end, invalidAction = icd9InvalidActions)

start \%i9mj\% end
}
\arguments{
\item{start,end}{is a character vector of ICD-9 codes. If fewer than five characters is
given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010"}

\item{invalidAction}{character string (unit length) containing one of:
  "ignore", "silent", "warn", "stop"

  - \code{ignore} no check for validity of ICD-9 code is made implicitly.
  This is the fastest option. If the function call is explicitly to check
  validity, e.g. icd9ValidShort(icd9Short = "12345", invalidAction =
  "ignore"), then the behavior is the same as \code{silent}.

  - \code{silent} invalid ICD-9 codes are replaced silently by \code{NA}
  (actually \code{NA_character_}). If the function returns \code{TRUE} or
  \code{FALSE} rather than the ICD-9 code itself, then \code{FALSE} is
  returned

  - \code{warn} invalid ICD-9 codes are replaced by \code{NA} with a warning
  revealing the invalid code(s).

  - \code{stop} stop with error if any invalid codes are found in input. This
  is the preferred method when doing one-time validation, e.g. of the
  co-morbidity mapping lists.}
}
\value{
character vector with range inclusive of start and end
}
\description{
accepts V, E or numeric codes. Does not validate codes beyond
  ensuring that the start and end of the range are of the same type. Will add
  leading zeroes when appropriate. User can strip them out with
  icd9DropLeadingZeroes if they wish.
}
\seealso{
Other ICD-9 ranges: \code{\link{\%i9d\%}},
  \code{\link{icd9ExpandRangeDecimal}};
  \code{\link{\%i9s\%}},
  \code{\link{icd9ExpandRangeShort}};
  \code{\link{icd9ChildrenDecimal}};
  \code{\link{icd9Children}},
  \code{\link{icd9ChildrenShort}};
  \code{\link{icd9CondenseToExplain}};
  \code{\link{icd9CondenseToMajor}};
  \code{\link{icd9ExpandMinor}},
  \code{\link{icd9ExpandMinorE}},
  \code{\link{icd9ExpandMinorNV}};
  \code{\link{icd9PrecedingMinors}},
  \code{\link{icd9SubsequentMinors}}
}

