% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9ExpandMinor}
\alias{icd9ExpandMinor}
\alias{icd9ExpandMinorE}
\alias{icd9ExpandMinorNV}
\title{expand decimal part of ICD-9 code to cover all possible sub-codes}
\usage{
icd9ExpandMinor(minor = "", invalidAction = c("ignore", "silent", "warn",
  "stop"))

icd9ExpandMinorNV(minor = "")

icd9ExpandMinorE(minor = "")
}
\arguments{
\item{minor}{character vector of 'minor' part of ICD-9 codes, i.e. that part
which falls after the decimal point, in decimal notation. (In 5 digit
notation, the 'major' part is be xyz, even when x and y are zero, thus the
last two characters represent the 'minor' part, in this case.)}
}
\value{
NA for invalid minor, otherwise a vector of all possible (perhaps
  non-existent) sub-divisions.
}
\description{
Accepts a single number or character input starting point for
  generation of all possible decimal parts of ICD9 code. e.g. giving an empty
  input will fill out 111 combinations, e..g .1 .11 .12 .... .2 ....
#examples #icd9ExpandMinor() # return all possible decimal parts of ICD9 codes
icd9ExpandMinor(1) # "1"  "10" "11" "12" "13" "14" "15" "16" "17" "18" "19"
icd9ExpandMinor("1") # same
}
\seealso{
Other ICD-9 ranges: \code{\link{\%i9d\%}},
  \code{\link{icd9ExpandRangeDecimal}};
  \code{\link{\%i9mj\%}}; \code{\link{\%i9s\%}},
  \code{\link{icd9ExpandRangeShort}};
  \code{\link{icd9ChildrenDecimal}};
  \code{\link{icd9Children}},
  \code{\link{icd9ChildrenShort}};
  \code{\link{icd9CondenseShort}};
  \code{\link{icd9CondenseToExplainShort}};
  \code{\link{icd9PrecedingMinors}},
  \code{\link{icd9SubsequentMinors}}
}
\keyword{internal}
\keyword{manip}

