% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/real.R
\name{is_defined}
\alias{is_defined}
\alias{is_defined.icd9}
\alias{is_defined.icd10cm}
\alias{is_defined.icd10}
\alias{is_defined.default}
\title{Check whether ICD-9 codes exist}
\usage{
is_defined(x, short_code = guess_short(x), ...)

\method{is_defined}{icd9}(x, short_code = guess_short(x),
  billable = FALSE, leaf = billable, ...)

\method{is_defined}{icd10cm}(x, short_code = guess_short(x),
  billable = FALSE, leaf = billable, ...)

\method{is_defined}{icd10}(x, short_code = guess_short(x),
  billable = FALSE, leaf = billable, ...)

\method{is_defined}{default}(x, short_code = guess_short(x), ...)
}
\arguments{
\item{x}{vector if ICD codes to test whether defined in certain ICD code list}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{...}{arguments passed on to other functions}

\item{billable}{single logical value, identical to 'leaf'. Leaf is preferred
as most adaptations of WHO ICD codes are not oriented around money.}

\item{leaf}{single logical value, whether to limit return codes also by
whether they are billable, i.e. leaf nodes. This is really only designed
for use with ICD-9-CM, ICD-10-CM etc, since the WHO versions are not
designed for billing, but for public health and death reporting.}

\item{leaf}{New synonym for 'billable', which will be deprecated.}
}
\value{
logical vector
}
\description{
This is different from syntactic validity: it looks up codes in the canonical
lists published by the CMS.
}
\details{
The source data from CMS, and code to generate the R data are included in the
source tree of this package.
}
\section{Methods (by class)}{
\itemize{
\item \code{icd9}: Check whether ICD-9 code are defined. (ICD-9-CM by
default)

\item \code{icd10cm}: Same for ICD-10-CM

\item \code{icd10}: Same for ICD-10, temporarily using ICD-10-CM until
ICD-10 WHO is available in this package

\item \code{default}: default method which will guess the ICD version (9
vs 10, maybe WHO vs CM or other in the future) and dispatches again on that
type.
}}

\keyword{internal}
