% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acoustic_auth.R
\name{acoustic_auth}
\alias{acoustic_auth}
\title{Connect to API and Obtain Access Token}
\usage{
acoustic_auth(org_client_id, org_client_secret, my_refresh_token, pod_number)
}
\arguments{
\item{org_client_id}{Organization's Client Id.}

\item{org_client_secret}{Organization's Client Secret.}

\item{my_refresh_token}{Your personal Refresh Token.}

\item{pod_number}{Pod number is the number in the URL, e.g.
engage1.silverpop.com.}
}
\value{
A vector with the session's access token.
}
\description{
Prior to attempting this you must have a Client Id, Client
Secret and Refresh Token. The first two are assigned on
an organization level; the latter must be created by
someone with an admin role in Acoustic and assigned to you.
}
\details{
Access tokens expire after four hours. Thus, this function should
be run each time you utilize the package and may need to be
re-called periodically if you have a session open for a long
duration.

It is not recommended that these authentication parameters be
stored directly in your code. There are various methods and
packages available that are more secure; this package does not
require you to use any one in particular.

More information on this available at https://developer.ibm.com/
customer-engagement/tutorials/
getting-started-oauth-watson-campaign-automation/ .
}
\examples{
\dontrun{
access_token <- acoustic_auth(org_client_id = "abc",
org_client_secret = "xyz",
my_refresh_token = "123")
}
}
