% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_read_hdr_data.R
\name{ifcb_read_hdr_data}
\alias{ifcb_read_hdr_data}
\title{Reads HDR Data from IFCB HDR Files}
\usage{
ifcb_read_hdr_data(
  hdr_files,
  gps_only = FALSE,
  verbose = TRUE,
  hdr_folder = deprecated()
)
}
\arguments{
\item{hdr_files}{A character string specifying the path to feature files or a folder path.}

\item{gps_only}{A logical value indicating whether to include only GPS information (latitude and longitude). Default is FALSE.}

\item{verbose}{A logical value indicating whether to print progress messages. Default is TRUE.}

\item{hdr_folder}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Use \code{hdr_files} instead.}
}
\value{
A data frame with sample names, GPS latitude, GPS longitude, and optionally timestamps.
}
\description{
This function reads all IFCB instrument settings information files (.hdr) from a specified directory.
}
\examples{
\dontrun{
# Extract all HDR data
hdr_data <- ifcb_read_hdr_data("path/to/data")
print(hdr_data)

# Extract only GPS data
gps_data <- ifcb_read_hdr_data("path/to/data", gps_only = TRUE)
print(gps_data)
}

}
