% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_extract_classified_images.R
\name{ifcb_extract_classified_images}
\alias{ifcb_extract_classified_images}
\title{Extract Taxa Images from MATLAB Classified Sample}
\usage{
ifcb_extract_classified_images(
  sample,
  classified_folder,
  roi_folder,
  out_folder,
  taxa = "All",
  threshold = "opt",
  overwrite = FALSE,
  use_python = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{sample}{A character string specifying the sample name.}

\item{classified_folder}{A character string specifying the directory containing the classified files.}

\item{roi_folder}{A character string specifying the directory containing the ROI files.}

\item{out_folder}{A character string specifying the directory to save the extracted images.}

\item{taxa}{A character string specifying the taxa to extract. Default is "All".}

\item{threshold}{A character string specifying the threshold to use ("none", "opt", "adhoc"). Default is "opt".}

\item{overwrite}{A logical value indicating whether to overwrite existing PNG files. Default is FALSE.}

\item{use_python}{Logical. If \code{TRUE}, attempts to read the \code{.mat} file using a Python-based method. Default is \code{FALSE}.}

\item{verbose}{A logical value indicating whether to print progress messages. Default is TRUE.}
}
\value{
No return value, called for side effects. Extracts and saves taxa images to a directory.
}
\description{
This function reads a MATLAB classified sample file (.mat) generated
by the \code{start_classify_batch_user_training} function from the \code{ifcb-analysis} repository (Sosik and Olson 2007),
extracts specified taxa images from the corresponding ROI files,
and saves each image in a specified directory.
}
\details{
If \code{use_python = TRUE}, the function tries to read the \code{.mat} file using \code{ifcb_read_mat()}, which relies on \code{SciPy}.
This approach may be faster than the default approach using \code{R.matlab::readMat()}, especially for large \code{.mat} files.
To enable this functionality, ensure Python is properly configured with the required dependencies.
You can initialize the Python environment and install necessary packages using \code{ifcb_py_install()}.

If \code{use_python = FALSE} or if \code{SciPy} is not available, the function falls back to using \code{R.matlab::readMat()}.
}
\examples{
\dontrun{
# Define the parameters
sample <- "D20230311T092911_IFCB135"
classified_folder <- "path/to/classified_folder"
roi_folder <- "path/to/roi_folder"
out_folder <- "path/to/outputdir"
taxa <- "All"  # or specify a particular taxa
threshold <- "opt"  # or specify another threshold

# Extract taxa images from the classified sample
ifcb_extract_classified_images(sample, classified_folder, roi_folder, out_folder, taxa, threshold)
}
}
\references{
Sosik, H. M. and Olson, R. J. (2007), Automated taxonomic classification of phytoplankton sampled with imaging-in-flow cytometry. Limnol. Oceanogr: Methods 5, 204–216.
}
\seealso{
\code{\link{ifcb_extract_pngs}} \code{\link{ifcb_extract_annotated_images}} \url{https://github.com/hsosik/ifcb-analysis}
}
