% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{aggregate_data}
\alias{aggregate_data}
\alias{aggregate_dt}
\title{Aggregate data by categorical variables}
\usage{
aggregate_data(
  data,
  group_vars,
  summaries,
  vars = NULL,
  names = NULL,
  quantiles = c(0.25, 0.75)
)

aggregate_dt(
  data,
  dt,
  dt_comp,
  group_vars = NULL,
  summaries,
  vars = NULL,
  names = NULL,
  quantiles = c(0.25, 0.75)
)
}
\arguments{
\item{data}{A dataframe or survey design object to be aggregated.}

\item{group_vars}{A character vector specifying the variables in \code{data} to '
be used as grouping factors.}

\item{summaries}{An unnamed character vector or named list of summary
functions to calculate for each group.
If unnamed, the vector elements should be names of variables in the
dataset for which summary statistics need to be calculated.
If named, the names should correspond to the summary functions
(e.g., "mean", "sd", "iqr") to be applied to each variable.}

\item{vars}{(Optional) A character vector specifying the names of variables
in the dataset for which summary statistics need to be calculated.
This argument is ignored if \code{summaries} is a named list.}

\item{names}{(Optional) A character vector or named list providing name
templates for the newly created variables. See details for more
information.}

\item{quantiles}{(Optional) A numeric vector specifying the desired
quantiles (e.g., c(0.25, 0.5, 0.75)).
See details for more information.}

\item{dt}{A character string representing the name of the date-time variable
in the dataset.}

\item{dt_comp}{A character string specifying the component of the date-time
to use for grouping.}
}
\value{
An aggregated dataframe containing the summary statistics for each
group, along with the tidyverse code used for the aggregation.
}
\description{
Summarizes non-categorical variables in a dataframe by grouping them
based on specified categorical variables and returns the aggregated result
along with the tidyverse code used to generate it.
}
\details{
The \code{aggregate_data()} function accepts any R function that returns a
single-value summary (e.g., \code{mean}, \code{var}, \code{sd}, \code{sum}, \code{IQR}). By default,
new variables are named \verb{\{var\}_\{fun\}}, where \code{{var}} is the variable name
and \code{{fun}} is the summary function used. The user can provide custom names
using the \code{names} argument, either as a vector of the same length as \code{vars},
or as a named list where the names correspond to summary functions (e.g.,
"mean" or "sd").

The special summary "missing" can be included, which counts the number of
missing values in the variable. The default name for this summary is
\verb{\{var\}_missing}.

If \code{quantiles} are requested, the function calculates the specified
quantiles (e.g., 25th, 50th, 75th percentiles), creating new variables for
each quantile. To customize the names of these variables, use \code{{p}} as a
placeholder in the \code{names} argument, where \code{{p}} represents the quantile
value. For example, using \code{names = "Q{p}_{var}"} will create variables like
"Q0.25_Sepal.Length" for the 25th percentile.
}
\section{Functions}{
\itemize{
\item \code{aggregate_dt()}: Aggregate data by dates and times

}}
\examples{
aggregated <-
    aggregate_data(iris,
        group_vars = c("Species"),
        summaries = c("mean", "sd", "iqr")
    )
code(aggregated)
head(aggregated)

}
\seealso{
\code{\link{code}}

\code{\link{aggregate_data}}
}
\author{
Tom Elliott, Owen Jin, Zhaoming Su

Zhaoming Su
}
