/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.charts;

import java.util.Arrays;
import umontreal.iro.lecuyer.charts.XYLineChart;
import umontreal.iro.lecuyer.charts.XYListSeriesCollection;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class PPPlot
extends XYLineChart {
    private double[][] U;
    private double[][] Lin;

    private void initLinear() {
        int m = 100;
        double h = 1.0 / (double)m;
        this.Lin = new double[2][m + 1];
        for (int i = 0; i <= m; ++i) {
            double d = h * (double)i;
            this.Lin[1][i] = d;
            this.Lin[0][i] = d;
        }
    }

    private void initPoints(ContinuousDistribution dist, double[] data, int numPoints) {
        int i;
        this.U = new double[2][numPoints];
        for (i = 0; i < numPoints; ++i) {
            this.U[1][i] = dist.cdf(data[i]);
        }
        Arrays.sort(this.U[1]);
        for (i = 0; i < numPoints; ++i) {
            this.U[0][i] = (double)(i + 1) / (double)numPoints;
        }
    }

    public PPPlot(String title, String XLabel, String YLabel, ContinuousDistribution dist, double[] X) {
        this(title, XLabel, YLabel, dist, X, X.length);
    }

    public PPPlot(String title, String XLabel, String YLabel, ContinuousDistribution dist, double[] X, int numPoints) {
        this.initPoints(dist, X, numPoints);
        this.initLinear();
        this.dataset = new XYListSeriesCollection(this.U, this.Lin);
        ((XYListSeriesCollection)this.dataset).setDashPattern(1, "dashed");
        this.init(title, XLabel, YLabel);
    }

    public PPPlot(String title, String XLabel, String YLabel, ContinuousDistribution dist, double[][] data, int r) {
        this(title, XLabel, YLabel, dist, data[r], data[r].length);
    }
}

