% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F011.make.gene.model.R
\name{make.gene.model}
\alias{make.gene.model}
\title{Make a gene model for clustering}
\usage{
make.gene.model(
  x = NULL,
  dispersion.limit = 1.5,
  base.mean.rank = 500,
  non.sig.col = "darkgray",
  right.sig.col = "chartreuse3",
  left.sig.col = "cadetblue3",
  disp.line.col = "black",
  rank.line.col = "red",
  my.out.put = "data",
  cell.size = 1.75,
  cell.transparency = 0.5,
  no.mito.model = TRUE,
  no.cell.cycle = TRUE,
  mark.mito = TRUE,
  interactive = TRUE,
  out.name = "plot"
)
}
\arguments{
\item{x}{An object of class iCellR.}

\item{dispersion.limit}{A number for taking the genes that have dispersion above this number, default = 1.5.}

\item{base.mean.rank}{A number taking the top genes ranked by base mean, default = 500.}

\item{non.sig.col}{Color for the genes not used for the model, default = "darkgray".}

\item{right.sig.col}{Color for the genes above the dispersion limit, default = "chartreuse3".}

\item{left.sig.col}{Color for the genes above the rank limit, default = "cadetblue3".}

\item{disp.line.col}{Color of the line for dispersion limit, default = "black".}

\item{rank.line.col}{Color of the line for rank limit, default = "red".}

\item{my.out.put}{Chose from "data" or "plot", default = "data".}

\item{cell.size}{A number for the size of the points in the plot, default = 1.75.}

\item{cell.transparency}{Color transparency for the points in the plot, default = 0.5.}

\item{no.mito.model}{If set to TRUE, mitochondrial genes would be excluded from the gene list made for clustering, default = TRUE.}

\item{no.cell.cycle}{If TRUE the cell cycle genes will be removed (s.phase and g2m.phase), default = TRUE.}

\item{mark.mito}{Mark mitochondrial genes in the plot, default = TRUE.}

\item{interactive}{If set to TRUE an interactive HTML file will be created, default = TRUE.}

\item{out.name}{If "interactive" is set to TRUE, the out put name for HTML, default = "plot".}
}
\value{
An object of class iCellR.
}
\description{
This function takes an object of class iCellR and provides a gene list for clustering based on the parameters set in the model.
}
\examples{
make.gene.model(demo.obj,
               dispersion.limit = 1.5,
               base.mean.rank = 500,
               no.mito.model = TRUE,
               mark.mito = TRUE,
               interactive = FALSE,
               my.out.put = "plot",
               out.name = "gene.model")

demo.obj <- make.gene.model(demo.obj,
                           dispersion.limit = 1.5,
                           base.mean.rank = 500,
                           no.mito.model = TRUE,
                           mark.mito = TRUE,
                           interactive = FALSE,
                           out.name = "gene.model")

head(demo.obj@gene.model)

}
