% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap}
\alias{bootstrap}
\title{Bootstrap incidence time series}
\usage{
bootstrap(x, randomise_groups = FALSE)
}
\arguments{
\item{x}{An \link[incidence2:incidence]{incidence2::incidence} object.}

\item{randomise_groups}{A \code{logical} indicating whether groups should be
randomised as well in the resampling procedure; respective group sizes will
be preserved, but this can be used to remove any group-specific temporal
dynamics. If \code{FALSE} (default), data are resampled within groups.}
}
\value{
An \code{incidence2} object.
}
\description{
This function can be used to bootstrap \link[incidence2:incidence]{incidence2::incidence} objects.
Bootstrapping is done by sampling with replacement the original input dates.
See \code{details} for more information on how this is implemented.
}
\details{
As original data are not stored in \link[incidence2:incidence]{incidence2::incidence} objects,
the bootstrapping is achieved by multinomial sampling of date bins weighted
by their relative incidence.
}
\examples{
if (requireNamespace("outbreaks", quietly = TRUE)) {
  data(fluH7N9_china_2013, package = "outbreaks")
  i <- incidence2::incidence(fluH7N9_china_2013, date_index = date_of_onset)
  bootstrap(i)
  bootstrap(i, randomise_groups = TRUE)
}

}
\seealso{
\code{\link[=find_peak]{find_peak()}} to use estimate peak date using bootstrap
}
\author{
Thibaut Jombart, Tim Taylor
}
