\name{spc.rubberband}
\alias{spc.rubberband}
\title{Rubberband baseline correction}
\usage{
  spc.rubberband(spc, ..., upper = FALSE, noise = 0,
    spline = TRUE)
}
\arguments{
  \item{spc}{hyperSpec object}

  \item{...}{further parameters handed to
  \code{\link[stats]{smooth.spline}}}

  \item{upper}{logical indicating whether the lower or
  upper part of the hull should be used}

  \item{noise}{noise level to be taken into account}

  \item{spline}{logical indicating whether the baseline
  should be an interpolating spline through the support
  points or piecewise linear.}
}
\value{
  hyperSpec object containing the baselines
}
\description{
  Rubberband baseline
}
\details{
  Baseline with support points determined from a convex
  hull of the spectrum.
}
\note{
  This function is still experimental
}
\examples{
plot (paracetamol [,, 175 ~ 1800])
bl <- spc.rubberband (paracetamol [,, 175 ~ 1800], noise = 300, df = 20)
plot (bl, add = TRUE, col = 2)
plot (paracetamol [,, 175 ~ 1800] - bl)
}
\author{
  Claudia Beleites
}
\seealso{
  \code{\link[hyperSpec]{spc.fit.poly}},
  \code{\link[hyperSpec]{spc.fit.poly.below}}

  \code{vignette ("baseline")}
}

