% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getEnsemble.R
\name{getEnsem_comb}
\alias{getEnsem_comb}
\title{Combine ensembles together}
\usage{
getEnsem_comb(..., list = NULL, nrow = 1, legend = TRUE, x = "",
  y = "", title = "", output = FALSE)
}
\arguments{
\item{...}{different ensembles generated by \code{getHisEnsem(, output = 'ggplot')}
or \code{getFrcEnsem(, output = 'ggplot')}, see details.}

\item{list}{If input is a list containing different ggplot data, use \code{list = inputlist}.}

\item{nrow}{A number showing the number of rows.}

\item{legend}{A boolean representing whether you want the legend. Sometimes when you combine
plots, there will be a lot of legends, if you don't like it, you can turn it off by setting
\code{legend = FALSE}, default is TRUE.}

\item{x}{A string of x axis name.}

\item{y}{A string of y axis name.}

\item{title}{A string of the title.}

\item{output}{A boolean, if chosen TRUE, the output will be given.}
}
\value{
A combined ensemble plot.
}
\description{
Combine ensembles together
}
\examples{
data(testdl)

a <- testdl[[1]]

# Choose example from "1994-2-4" to "1996-1-4"


b1<- getHisEnsem(a, example = c('1995-2-4', '1996-1-4'), plot = 'cum', output = 'ggplot',
                 name = 1)

b2 <- getHisEnsem(a, example = c('1995-4-4', '1996-3-4'), plot = 'cum', output = 'ggplot',
                 name = 2)

getEnsem_comb(b1, b2)
getEnsem_comb(list = list(b1, b2), nrow = 2)

# More examples can be found in the user manual on http://yuanchao-xu.github.io/hyfo/
}
\references{
\itemize{
\item H. Wickham. ggplot2: elegant graphics for data analysis. Springer New York, 2009.
\item Santander Meteorology Group (2015). downscaleR: Climate data manipulation and
statistical downscaling. R package version 0.6-0.
https://github.com/SantanderMetGroup/downscaleR/wiki
}
}

