% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_swe_derive.R
\name{swe_derive}
\alias{swe_derive}
\title{Snow Water Equivalent to melt or snowfall}
\usage{
swe_derive(x, col_name, out_name = NULL, case)
}
\arguments{
\item{x}{data frame or tibble with class Date or POSIX* in the
first column.}

\item{col_name}{string with column(s) name(s) where to apply the function.}

\item{out_name}{optional. String with new column(s) name(s). If you
set it as \code{NULL}, the function will overwrite the original table.}

\item{case}{string vector with "sf" (meaning snowfall) or "m" (meaning melt).}
}
\value{
The same data frame but with the derived series.
}
\description{
Derive melt or snowfall series from snow water
equivalent measurements (snow pillows measurements).
}
\examples{

# set path to file
path_file <- system.file('extdata', 'dgi_toscas.xlsx',
             package = 'hydrotoolbox')

# swe table
swe_toscas <- read_dgi(path = path_file,
                       sheet = 'swe',
                       out_name = 'swe(mm)')

# add melt and snowfall
swe_toscas <-
  swe_toscas \%>\%
  swe_derive(col_name = rep('swe(mm)', 2),
             out_name = c('melt(mm)', 'snowfall(mm)'),
             case = c('m', 'sf') )


}
