% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_fill_table.R
\name{fill_table}
\alias{fill_table}
\title{Find non-reported dates and fill them with \code{NA_*}}
\usage{
fill_table(x, col_name = "all", by = NULL)
}
\arguments{
\item{x}{data frame (or tibble) with class \code{Date} or \code{POSIX*}
in the first column.}

\item{col_name}{string with column(s) name(s) to fill.}

\item{by}{string with a valid time step (e.g.: \code{"month",
"day", "6 hour", "3 hour", "1 hour", "15 min"}).}
}
\value{
A data frame (or tibble) with the date and the filled numeric variable(s).
}
\description{
Automatically finds non recorded date periods and fills
 them with \code{NA_real_} values.
}
\examples{

# let's use a synthetic example to illustrate the use of the function
dates <- seq.Date(from = as.Date('1980-01-01'),
                 to = as.Date('2020-01-01'), by = 'day' )
var   <- runif(n = length(dates), min = 0, max = 100)

met_var <- data.frame(date = dates, random = var)[-c(50:100, 251, 38) , ]

met_var_fill <- fill_table(x = met_var, by = 'day')


}
