% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventBaseflow.R
\name{eventBaseflow}
\alias{eventBaseflow}
\title{Event identification (using baseflow index)}
\usage{
eventBaseflow(data, BFI_Th = 0.5, min.diff = 1, out.style = "summary")
}
\arguments{
\item{data}{The data vector (e.g. a streamflow time series)}

\item{BFI_Th}{Minimum BFI to identify baseflow}

\item{min.diff}{Minimum length for an event}

\item{out.style}{The type of output (currently either "summary" or "none")}
}
\value{
By default, the \code{out.style} returns the indices of the maximum in each event, as well as the value of
the maximum and the sum of the \code{data} in each event, alongside the start and end of the events. Otherwise just
the indices of start and end of events as a two column dataframe are returned.
}
\description{
Events are identified on the basis of the Baseflow Index (BFI).
}
\details{
Any flow above the \code{BFI_Th} will be considered an event with a minimum event separation of \code{min.diff}.
}
\examples{
# Example extracting events from quickflow
bf = baseflowB(dataBassRiver)
BFI_res = eventBaseflow(dataBassRiver, BFI_Th = 0.5, min.diff = 1)
}
\references{
Kaur, S., Horne, A., Stewardson, M.J., Nathan, R., Costa, A.M., Szemis, J.M., & Webb, J.A., (2017)
Challenges for determining frequency of high flow spells for varying thresholds in environmental flows programmes. J. Ecohydraulics 2, 28–37.
}
\seealso{
\code{\link{calcStats}} \code{\link{eventBaseflow}} \code{\link{eventMaxima}} \code{\link{eventPOT}}
}
\keyword{events}
