\name{sqcoefvec}
\alias{sqcoefvec}
\title{Compute coefficients required for approximaing the wavelet
	transform using the square of wavelets.
}
\description{Essentially, part of a method for computing a wavelet-like
	transform using the squares of wavelets rather than the
	wavelets themselves.
}
\usage{
sqcoefvec(m0, filter.number = 10, family = "DaubLeAsymm",
	resolution = 4096, stop.on.error = FALSE, plot.it = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{m0}{The number of scales finer than the square wavelet being
	approximated. Usually, 2 or 3 is enough. 
}
  \item{filter.number}{Number of vanishing moments of underlying wavelet.
}
  \item{family}{Family of underlying wavelet
}
  \item{resolution}{Function values of the wavelet itself are generated by
	a high-resolution approximation. This argument specifies
	exactly how many values.
}
  \item{stop.on.error}{This argument is supplied to the \code{integrate}
	function which performs numerical integration within this code.
}
  \item{plot.it}{Plots showing the approximation are plotted.
}
}
\details{
The idea is that the square of a wavelet (the square wavelet)
     is approximated by wavelets at a finer scale. The argument \code{m0}
     controls how many levels below the original scale are used.
     Essentially, this function computes a representation of the
     original square wavelet in terms of finer scale wavelets.  Hence,
     when a decomposition of another function with respect to the square
     wavelets is required, one can compute the representation with
     respect to a regular wavelet decomposition and then apply the
     wavelet to  square wavelet transform to turn it into a square wavelet
     representation.

     This idea originally used for performing `powers of wavelets'
     transforms in Herrick (2000) and Barber, Nason and Silverman
     (2002) and for the mod-wavelets is described in Fryzlewicz, Nason
     and von Sachs (2008).

}
\value{A list with the following components:
\item{ll}{Vector containing integers between the lower and upper limit
          of the wavelets required at the finer scale.}

\item{ecoef}{The appropriate coefficients that approximate the mod wavelet
          at the finer scale.}

\item{m0}{The number of scales finer below the scale that the function
          is at}
\item{filter.number}{The wavelet filter number used}
\item{family}{The wavelet family used}
\item{ecode}{An error code, if zero then ok, otherwise returns 1}
\item{ians}{The actual return values from the internal call to the
          \code{integrate} function}
}
\references{
Barber, S., Nason, G.P. and Silverman, B.W. (2002) Posterior
     probability intervals for wavelet thresholding.
        \emph{J. R. Statist.  Soc. B}, \bold{64}, 189-206.

Fryzlewicz, P., Nason, G.P. and von Sachs, R. (2008) A
wavelet-Fisz approach to spectrum estimation.
\emph{J. Time Ser.  Anal.},
\bold{29}, 868-880.

Herrick, D.R.M. (2000) \emph{Wavelet Methods for Curve Estimation}, PhD
     thesis, University of Bristol, U.K.

Nason, G.P. and Savchev, D. (2014) White noise testing using
wavelets. \emph{Stat}, \bold{3}, 351-362.
\url{http://dx.doi.org/10.1002/sta4.69}
}
\author{
Guy Nason
}

\seealso{\code{\link{sqwd}}, \code{\link{sqndwd}},
        \code{\link{sqndwdecomp}}
}
\examples{
#
# This function is not really designed to be used by the casual user
#
tmp <- sqcoefvec(m0=2, filter.number=4)
}
\keyword{math}
