% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hwe.R
\name{freqnext}
\alias{freqnext}
\title{Update genotype frequencies after one generation}
\usage{
freqnext(freq, alpha, segmat = NULL, more = FALSE, check = TRUE)
}
\arguments{
\item{freq}{The current genotype frequencies. This should be a
vector of length K+1, where K is the ploidy of the species.
\code{freq[i]} could contain the proportion of individuals
that have genotype \code{i-1}.}

\item{alpha}{A numeric vector containing the double reduction parameter(s).
This should be a
vector of length \code{floor(ploidy/4)} where \code{alpha[i]}
is the probability of exactly \code{i} pairs of IBDR alleles
being in the gamete. Note that \code{sum(alpha)} should be less than
1, as \code{1 - sum(alpha)} is the probability of no double reduction.}

\item{segmat}{You can provide your own segregation matrix.
\code{segmat[i, j]} is the probability that a parent with
dosage \code{i-1} produces a gamete with dosage \code{j-1}.}

\item{more}{A logical. Should we return more output (\code{TRUE}) or
less (\code{FALSE}). See the Value section for details.}

\item{check}{Should we correct for minor numerical issues? Defaults
to \code{TRUE}.}
}
\value{
If \code{more = FALSE}, then returns a vector of length
\code{length(freq)} that contains the updated genotype frequencies
after one generation of random mating. If \code{more = TRUE}, then
returns a list with these genotype frequencies (\code{q}) as well as the
parental gamete frequencies (\code{p}).
}
\description{
After one generation of random mating, update the genotype
frequencies.
}
\examples{
freq <- c(0.5, 0, 0, 0, 0.5)
freqnext(freq = freq, alpha = 0)

}
\author{
David Gerard
}
