% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulation.R
\name{add_rows}
\alias{add_rows}
\alias{add_columns}
\title{Insert one matrix into another.}
\usage{
add_rows(x, y, after = nrow(x), ...)

add_columns(x, y, after = ncol(x), ...)
}
\arguments{
\item{x}{A matrix-like object, e.g. a huxtable}

\item{y}{Matrix or vector to be inserted into \code{x}}

\item{after}{Row or column after which \code{y} is inserted. Can be 0. Can be a row or column name.
By default, inserts \code{y} after the end of \code{x}.}

\item{...}{Arguments passed to \code{\link[=rbind]{rbind()}} or \code{\link[=cbind]{cbind()}}}
}
\value{
For \code{add_rows}, the result of \code{rbind(x[1:after,], y, x[-(1:after),]}. For \code{add_columns}
the same but with columns. \code{after = 0} and \code{after = nrow(x)} or \code{ncol(x)} are handled correctly.
}
\description{
These functions combine two matrix-like objects and return the result.
}
\details{
For \code{huxtable} objects, arguments in \code{...} can include \code{copy_cell_props}.
}
\examples{
ht <- hux(Jam = c('Blackberry', 'Strawberry'), Price = c(1.90, 1.80), add_colnames = TRUE)
ht2 <- hux('Gooseberry', 2.10)
add_rows(ht, ht2)
add_rows(ht, ht2, after = 1)
mx <- matrix(c('Sugar', '50\%', '60\%', 'Weight (g)', 300, 250), 3, 2)
add_columns(ht, mx, after = 'Jam')
ht <- hux(a = 1:3, b = 1:3)
ht2 <- hux(d = letters[1:3])
add_columns(ht, ht2, after = "a")
}
\seealso{
\code{\link[=insert_row]{insert_row()}} and \code{\link[=insert_column]{insert_column()}}, which insert multiple values into a single row.
}
