% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row-col-fns.R
\name{where}
\alias{where}
\title{Return array indices where expression is true}
\usage{
where(expr)
}
\arguments{
\item{expr}{An R expression}
}
\value{
A matrix of row and column indices of cells where \code{expr} is \code{TRUE}.
}
\description{
This is a simple wrapper around \code{which(..., arr.ind = TRUE)}, for
use in \link[=rowspecs]{row specifications}.
}
\examples{
ht <- hux(a = 1:3, b = 4:6, add_colnames = TRUE)
where(ht > 2)
where(is_a_number(ht))

}
