% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/huxtable.R
\name{huxtable}
\alias{huxtable}
\alias{hux}
\alias{as_huxtable}
\alias{as_hux}
\alias{as_huxtable.default}
\alias{is_huxtable}
\alias{is_hux}
\title{Create a huxtable}
\usage{
huxtable(..., add_colnames = getOption("huxtable.add_colnames", FALSE),
  add_rownames = FALSE, autoformat = getOption("huxtable.autoformat", TRUE))

hux(..., add_colnames = getOption("huxtable.add_colnames", FALSE),
  add_rownames = FALSE, autoformat = getOption("huxtable.autoformat", TRUE))

as_huxtable(x, ...)

as_hux(x, ...)

\method{as_huxtable}{default}(x,
  add_colnames = getOption("huxtable.add_colnames", FALSE),
  add_rownames = FALSE, autoformat = getOption("huxtable.autoformat", TRUE),
  ...)

is_huxtable(x)

is_hux(x)
}
\arguments{
\item{...}{For \code{huxtable}, named list of values as in \code{\link[=data.frame]{data.frame()}}. For \code{as_huxtable},
extra arguments.}

\item{add_colnames}{If \code{TRUE}, add a first row of column names to the huxtable.}

\item{add_rownames}{If \code{TRUE}, add a first column of row names, named 'rownames', to the huxtable.}

\item{autoformat}{If \code{TRUE}, automatically format columns by type. See below.}

\item{x}{An object to convert to a huxtable.}
}
\value{
An object of class \code{huxtable}.
}
\description{
\code{huxtable}, or \code{hux}, creates a huxtable object.
}
\details{
If you use \code{add_colnames} or \code{add_rownames}, be aware that these will shift your rows and columns
along by one: your old row/column 1 will now be row/column 2, etc.

\code{add_colnames} currently defaults to \code{FALSE}, but this will change in future. You can set
the default globally by setting \code{options("huxtable.add_colnames")} to \code{TRUE} or \code{FALSE}.

\code{as_huxtable} and \code{as_hux} convert an object to a huxtable.
Conversion methods exist for data frames, tables, ftables, matrices and (most) vectors.
}
\section{Automatic formatting}{


If \code{autoformat} is \code{TRUE}, then columns will have \code{\link[=number_format]{number_format()}} and \code{\link[=align]{align()}} properties
set automatically, as follows:
\itemize{
\item Integer columns will have \code{number_format} set to 0.
\item Other numeric columns will have \code{number_format} set to \code{"\%.3g"}.
\item All other columns will have \code{number_format} set to \code{NA} (no formatting).
\item Integer, \code{Date} and date-time (i.e. \code{POSIXct} and \code{POSIXlt}) columns will be right-aligned.
\item Other numeric columns will be aligned on \code{options("OutDec")}, usually \code{"."}.
\item Other columns will be left aligned.
}

You can change these defaults by editing \code{options("huxtable.autoformat_number_format")} and
\code{options("huxtable.autoformat_align")}. See \link{huxtable-package} for more details.

Automatic alignment also applies to column headers if \code{add_colnames} is \code{TRUE}; headers of
columns aligned on a decimal point will be right-aligned. Automatic number formatting does not
apply to column headers.
}

\examples{
ht <- huxtable(column1 = 1:5, column2 = letters[1:5])
dfr <- data.frame(a = 1:5, b = letters[1:5], stringsAsFactors = FALSE)
as_huxtable(dfr)

}
