% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abs_diff.R
\name{abs_diff}
\alias{abs_diff}
\alias{max_abs_diff}
\title{Absolute difference}
\usage{
abs_diff(x, y, nThread = getOption("hutilscpp.nThread", 1L), option = 1L)

max_abs_diff(x, y, nThread = getOption("hutilscpp.nThread", 1L))
}
\arguments{
\item{x, y}{Atomic, numeric, equilength vectors.}

\item{nThread}{Number of threads to use.}

\item{option}{An integer, provides backwards-compatible method to change results.
\describe{
\item{0}{Return \code{max(abs(x - y))} (without allocation).}
\item{1}{Return \code{abs(x - y)} with the expectation that every element will be \code{integer},
returning a \code{double} only if required.}
\item{2}{Return \code{abs(x - y)} but always a \code{double} vector, regardless of necessity.}
}}
}
\description{
Equivalent to \code{abs(x - y)} but aims to be faster by
avoiding allocations.
}
\examples{
x <- sample(10)
y <- sample(10)
abs_diff(x, y)
max_abs_diff(x, y)

}
