% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{ranged.to.data.frame}
\alias{ranged.to.data.frame}
\title{Convert RangedData/GRanges to a data.frame}
\usage{
ranged.to.data.frame(ranged, include.cols = FALSE, use.names = TRUE)
}
\arguments{
\item{ranged}{A RangedData or GRanges object}

\item{include.cols}{logical, whether to also bring across non-positional
columns to the resulting data.frame}

\item{use.names}{logical, whether to keep the rownames from the
original object for the output. Only has an effect when include.cols=FALSE,
otherwise original rownames are always kept.}
}
\value{
A data.frame with columns chr, start and end, and depending on
chosen parameters, the same rownames as the input, and optionally the
same additional columns.
}
\description{
Convert a RangedData/GRanges object to a data.frame with columns
chr, start and end. Default is to only translate the chromosome and
position information, which is faster. Using 'include.cols'=TRUE
allows all the columns from 'ranged' to be taken across to the resulting
data.frame.
}
\examples{
rd <- rranges(9,GRanges=FALSE, fakeids=TRUE)
rd[["fakecol"]] <- sample(nrow(rd))
rd[["rs.id"]] <- paste0("rs",sample(10000,9))
ranged.to.data.frame(rd)
ranged.to.data.frame(rd,,FALSE)
ranged.to.data.frame(rd,TRUE) # keep all the columns
df.to.GRanges(ranged.to.data.frame(rd,TRUE)) # inverse returns original
}
\seealso{
\code{\link{df.to.ranged}}, \code{\link{df.to.GRanges}}
}

