% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/include_image.R
\name{include_image}
\alias{include_image}
\title{Image layer}
\usage{
include_image(
  label,
  value,
  size,
  position = NA,
  type = "static",
  units = "cm",
  opts = NA
)
}
\arguments{
\item{label}{label output}

\item{value}{column or path}

\item{size}{image size}

\item{position}{position coordinate}

\item{type}{type of entry: dynamic or static}

\item{units}{units for the label options}

\item{opts}{R magick funtions}
}
\value{
data frame
}
\description{
Insert image in label
}
\examples{

\donttest{

library(huito)
library(gsheet)

url <- paste0("https://docs.google.com/spreadsheets/d/"
       , "1q0EZmZBt52ca-0VbididjJy2jXTwf06laJpzvkQJWvc/edit#gid=107939497")
fb <- gsheet2tbl(url)

label <- label_layout(data = fb
               , size = c(10, 2.5)
               ) \%>\%
         include_image(
               value = "https://inkaverse.com/reference/figures/logo.png"
               , size = c(2,2)#'                
               , position = c(1.2, 1.25)
               ) \%>\% 
         label_print("sample")

}

}
