% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_prelevements.R
\name{get_prelevements_points_prelevement}
\alias{get_prelevements_points_prelevement}
\alias{get_prelevements_ouvrages}
\alias{get_prelevements_chroniques}
\title{Retrieve data from API "Prélèvements en eau"}
\usage{
get_prelevements_points_prelevement(...)

get_prelevements_ouvrages(...)

get_prelevements_chroniques(...)
}
\arguments{
\item{...}{parameters of the queries and their values in the format
\verb{Param1_Name = "Param1 value", Param2_Name = "Param2 value"}, use the
function \link{list_params} for a list of the available filter parameters
for a given API endpoint and see the API documentation for their description}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row by record and one column by field.
}
\description{
Available endpoints are:
\itemize{
\item \code{get_prelevements_points_prelevement} retrieves withdrawal points
\item \code{get_prelevements_ouvrages} retrieves withdrawal devices
\item \code{get_prelevements_chroniques} retrieves time series of withdrawals
}

See the API documentation for available filter parameters: \url{https://hubeau.eaufrance.fr/page/api-prelevements-eau}
}
\examples{
\dontrun{
# Retrieve the withdrawal points located in Romilly-sur-Seine
get_prelevements_points_prelevement(code_commune_insee = "10323")

# Retrieve the withdrawal devices located in Romilly-sur-Seine
get_prelevements_ouvrages(code_commune_insee = "10323")

# Retrieve the withdrawal time series of the devices located in Romilly-sur-Seine
get_prelevements_chroniques(code_commune_insee = "10323")
}
}
