% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/date.R
\name{parse_http_date}
\alias{http_date}
\alias{parse_http_date}
\title{Parse and print http dates.}
\usage{
parse_http_date(x, failure = NA)

http_date(x)
}
\arguments{
\item{x}{For \code{parse_http_date}, a character vector of strings to parse.
  All elements must be of the same type.

  For \code{http_date}, a \code{POSIXt} vector.}

\item{failure}{What to return on failure?}
}
\value{
A POSIXct object if succesful, otherwise \code{failure}
}
\description{
As defined in RFC2616,
\url{http://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.3}, there are
three valid formats:
\itemize{
 \item Sun, 06 Nov 1994 08:49:37 GMT  ; RFC 822, updated by RFC 1123
 \item Sunday, 06-Nov-94 08:49:37 GMT ; RFC 850, obsoleted by RFC 1036
 \item Sun Nov  6 08:49:37 1994       ; ANSI C's asctime() format
}
}
\examples{
parse_http_date("Sun, 06 Nov 1994 08:49:37 GMT")
parse_http_date("Sunday, 06-Nov-94 08:49:37 GMT")
parse_http_date("Sun Nov  6 08:49:37 1994")

http_date(Sys.time())
}

