% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cache.R
\name{cache_info}
\alias{cache_info}
\alias{rerequest}
\title{Compute caching information for a response.}
\usage{
cache_info(r)

rerequest(r)
}
\arguments{
\item{r}{A response}
}
\description{
\code{cache_info()} gives details of cacheability of a response,
\code{rerequest()} re-performs the original request doing as little work
as possible (if not expired, returns response as is, or performs
revalidation if Etag or Last-Modified headers are present).
}
\examples{
# Never cached, always causes redownload
r1 <- GET("https://www.google.com")
cache_info(r1)
r1$date
rerequest(r1)$date

# Expires in a year
r2 <- GET("https://www.google.com/images/srpr/logo11w.png")
cache_info(r2)
r2$date
rerequest(r2)$date

# Has last-modified and etag, so does revalidation
r3 <- GET("http://httpbin.org/cache")
cache_info(r3)
r3$date
rerequest(r3)$date

# Expires after 5 seconds
\dontrun{
r4 <- GET("http://httpbin.org/cache/5")
cache_info(r4)
r4$date
rerequest(r4)$date
Sys.sleep(5)
cache_info(r4)
rerequest(r4)$date
}
}

