% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\name{stop_for_http_problem}
\alias{stop_for_http_problem}
\alias{stop_for_bad_request}
\alias{stop_for_unauthorized}
\alias{stop_for_forbidden}
\alias{stop_for_not_found}
\alias{stop_for_conflict}
\alias{stop_for_internal_server_error}
\title{Signal an Error Caused by an HTTP Problem}
\usage{
stop_for_http_problem(
  detail = NULL,
  status = 500L,
  type = NULL,
  title = NULL,
  instance = NULL,
  ...
)

stop_for_bad_request(detail = NULL, instance = NULL, ...)

stop_for_unauthorized(detail = NULL, instance = NULL, ...)

stop_for_forbidden(detail = NULL, instance = NULL, ...)

stop_for_not_found(detail = NULL, instance = NULL, ...)

stop_for_conflict(detail = NULL, instance = NULL, ...)

stop_for_internal_server_error(detail = NULL, instance = NULL, ...)
}
\arguments{
\item{detail}{A human-readable string giving more detail about the error,
if possible.}

\item{status}{The HTTP status code appropriate for the response.}

\item{type}{A URL pointing to human-readable documentation for this type of
problem. When \code{NULL}, the type is generated based on the status code; see
\code{\link[=http_problem_types]{http_problem_types()}} for a list of the defaults.}

\item{title}{A \href{https://tools.ietf.org/html/rfc7807#section-3.1}{"short, human-readable summary of the problem type"}.
When \code{NULL}, the title is generated based on the status code; see
\code{\link[=http_problem_types]{http_problem_types()}} for a list of the defaults.}

\item{instance}{A URL that identifies the specific occurrence of the
problem, if possible. When \code{NULL} this field is simply excluded.}

\item{...}{Additional fields added to the problem as \href{https://tools.ietf.org/html/rfc7807#section-3.2}{Extension Members}.}
}
\value{
These functions call \code{stop()} with a custom \link{condition} (with class
\code{"http_problem_error"}), so they do not return a value.
}
\description{
The various \verb{stop_for_*()} functions leverage R's condition system to signal
an error with a custom type embedding the "Problem Details" structure
defined in \href{https://tools.ietf.org/html/rfc7807}{RFC 7807}.

They can be used for reporting errors from HTTP APIs in a standard way.

There are also helper methods for the most common HTTP problems:
HTTP 400 Bad Request, 404 Not Found, 401 Unauthorized, 403 Forbidden, 409
Conflict, and 500 Internal Server Error.
}
\examples{
tryCatch(
  stop_for_bad_request("Parameter 'id' must be a number."),
  error = function(e) {
    str(e)
  }
)
}
\seealso{
\link{http_problem} for creating the structure directly.
}
