% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-verbs.R
\name{cachedPOST}
\alias{cachedPOST}
\title{Cache the response of a POST}
\usage{
cachedPOST(url, ...)
}
\arguments{
\item{url}{character URL of the request}

\item{...}{additional arguments passed to the httr functions}
}
\value{
The corresponding httr response object, potentially read from cache
}
\description{
Some APIs have resources where a POST is used to send a command that returns
content and doesn't modify state. In this case, it's more like a GET. This
may occur where one might normally GET but the request URI would be too long
for the server to accept. \code{cachedPOST} thus behaves more like
\code{GET}, checking for a cached response before performing the request and
setting cache if the request is successful. It does no cache dropping, unlike
\code{\link[httpcache]{POST}}.
}

