% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_avday.R
\name{h_avday}
\alias{h_avday}
\title{Daily average over a sequence of several years}
\usage{
h_avday(file, start = NA, end = NA, mhy = 1, precip = FALSE, dig = 1)
}
\arguments{
\item{file}{File name to proceed}

\item{start}{Starting date (default = NA)}

\item{end}{Ending date (default = NA)}

\item{mhy}{Starting month of the hydrological year (default = 1)}

\item{precip}{Precipitation time series (default = FALSE)}

\item{dig}{Number of significant digits for Value (default = 1)}
}
\description{
Daily average over a sequence of several years
}
\details{
The function means the values of each calendar day over a period larger 
than 4 years (i.e. it includes at least one Feb 29 day). The result is transfered
to the last possible hydrological year of the interval.
 
 In the special case of precipitation, where the distribution is discontinuous 
 over time, the original values of the last hydrological year are replaced by values 
 corrected proportionately.
}
\examples{
\dontrun{

f <- h_avday(f,   start=NA, end=NA, mhy=10, precip=TRUE, dig=1)
}

}
\author{
P. Chevallier - Nov 2022
}
