% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmlTable_style_handlers.R
\name{addHtmlTableStyle}
\alias{addHtmlTableStyle}
\alias{appendHtmlTableStyle}
\title{Add/set css and other style options}
\usage{
addHtmlTableStyle(
  x,
  align = NULL,
  align.header = NULL,
  align.cgroup = NULL,
  css.rgroup = NULL,
  css.rgroup.sep = NULL,
  css.tspanner = NULL,
  css.tspanner.sep = NULL,
  css.total = NULL,
  css.cell = NULL,
  css.cgroup = NULL,
  css.header = NULL,
  css.header.border_bottom = NULL,
  css.class = NULL,
  css.table = NULL,
  pos.rowlabel = NULL,
  pos.caption = NULL,
  col.rgroup = NULL,
  col.columns = NULL,
  padding.rgroup = NULL,
  padding.tspanner = NULL
)

appendHtmlTableStyle(
  x,
  align = NULL,
  align.header = NULL,
  align.cgroup = NULL,
  css.rgroup = NULL,
  css.rgroup.sep = NULL,
  css.tspanner = NULL,
  css.tspanner.sep = NULL,
  css.total = NULL,
  css.cell = NULL,
  css.cgroup = NULL,
  css.header = NULL,
  css.header.border_bottom = NULL,
  css.class = NULL,
  css.table = NULL,
  pos.rowlabel = NULL,
  pos.caption = NULL,
  col.rgroup = NULL,
  col.columns = NULL,
  padding.rgroup = NULL,
  padding.tspanner = NULL
)
}
\arguments{
\item{x}{The object that you later want to pass into \code{\link{htmlTable}}.}

\item{align}{A character strings specifying column alignments, defaulting to \code{'c'}
to center. Valid chars for alignments are l = left, c = center and r = right. You can also specify
\code{align='c|c'} and other LaTeX tabular formatting. If you want to set the alignment of the
rownames this string needst to be \code{ncol(x) + 1}, otherwise it automatically
pads the string with a left alignment for the rownames.}

\item{align.header}{A character strings specifying alignment for column header,
defaulting to centered, i.e. \code{\link[base]{paste}(rep('c',ncol(x)),collapse='')}.}

\item{align.cgroup}{The justification of the \code{cgroups}}

\item{css.rgroup}{CSS style for the rgroup, if different styles are wanted for each of the
rgroups you can just specify a vector with the number of elements.}

\item{css.rgroup.sep}{The line between different rgroups. The line is set to the TR element
of the lower rgroup, i.e. you have to set the border-top/padding-top etc to a line with
the expected function. This is only used for rgroups that are printed. You can specify
different separators if you give a vector of rgroup - 1 length (this is since the first
rgroup doesn't have a separator).}

\item{css.tspanner}{The CSS style for the table spanner.}

\item{css.tspanner.sep}{The line between different spanners.}

\item{css.total}{The css of the total row if such is activated.}

\item{css.cell}{The css.cell element allows you to add any possible CSS style to your
table cells. See section below for details.}

\item{css.cgroup}{The same as \code{css.class} but for cgroup formatting.}

\item{css.header}{The header style, not including the cgroup style}

\item{css.header.border_bottom}{The header bottom-border style, e.g. \code{border-bottom: 1px solid grey}}

\item{css.class}{The html CSS class for the table. This allows directing html
formatting through \href{http://www.w3schools.com/Css/}{CSS}
directly at all instances of that class. \emph{Note:} unfortunately the
CSS is frequently ignored by word processors. This option
is mostly inteded for web-presentations.}

\item{css.table}{You can specify the the style of the table-element using this parameter}

\item{pos.rowlabel}{Where the rowlabel should be positioned. This value can be \code{"top"},
\code{"bottom"}, \code{"header"}, or a integer between \code{1} and \code{nrow(cgroup) + 1}. The options
\code{"bottom"} and \code{"header"} are the same, where the row label is presented at the same level as
the header.}

\item{pos.caption}{Set to \code{"bottom"} to position a caption below the table
instead of the default of \code{"top"}.}

\item{col.rgroup}{Alternating colors (zebra striping/banded rows) for each \code{rgroup}; one or two colors
is recommended and will be recycled.}

\item{col.columns}{Alternating colors for each column.}

\item{padding.rgroup}{Generally two non-breakings spaces, i.e. \code{&nbsp;&nbsp;}, but some
journals only have a bold face for the rgroup and leaves the subelements unindented.}

\item{padding.tspanner}{The table spanner is usually without padding but you may specify padding
similar to \code{padding.rgroup} and it will be added to all elements, including the rgroup elements.
This allows for a 3-level hierarchy if needed.}
}
\value{
\code{x} with the style added as an attribute that the htmlTable then can use for formatting.
}
\description{
This function is a preprocessing step before applying the \code{\link{htmlTable}} function.
You use this to style your tables with HTML cascading style sheet features.
}
\details{
The function stores the current theme (see \code{\link{setHtmlTableTheme}}) + custom styles
to the provided object as an \code{\link[base]{attributes}}. It is stored under the element
\code{htmlTable.style} in the form of a list object.
}
\section{The \code{css.cell} argument}{


The \code{css.cell} parameter allows you to add any possible CSS style
to your table cells.  \code{css.cell} can be either a vector or a matrix.

If  \code{css.cell} is a \emph{vector}, it's assumed that the styles should be repeated
throughout the rows (that is, each element in css.cell specifies the style
for a whole column of 'x').

In the case of  \code{css.cell} being a \emph{matrix} of the same size of the \code{x} argument,
each element of \code{x} gets the style from the corresponding element in css.cell.  Additionally,
the number of rows of \code{css.cell} can be \code{nrow(x) + 1} so the first row of of \code{css.cell}
specifies the style for the header of \code{x}; also the number of columns of \code{css.cell}
can be \code{ncol(x) + 1} to include the specification of style for row names of \code{x}.

Note that the \code{text-align} CSS field in the \code{css.cell} argument will be overriden
by the \code{align} argument.

Excel has a specific css-style, \code{mso-number-format} that can be used for improving the
copy-paste functionality. E.g. the style could be written as: \code{css_matrix <-
matrix( data = "mso-number-format:\"\\@\"", nrow = nrow(df), ncol = ncol(df))}
}

\examples{
library(magrittr)
matrix(1:4, ncol = 2) \%>\%
  addHtmlTableStyle(align = "c", css.cell = "background-color: orange;") \%>\%
  htmlTable(caption = "A simple style example")
}
\concept{htmlTableStyle}
