% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_statistics.R
\name{dimnames.hstats_matrix}
\alias{dimnames.hstats_matrix}
\title{Dimnames of "hstats_matrix" Object}
\usage{
\method{dimnames}{hstats_matrix}(x)
}
\arguments{
\item{x}{An object of class "hstats_matrix".}
}
\value{
Dimnames of the statistics matrix.
}
\description{
Extracts dimnames of the "M" matrix in \code{x}. Implies \code{rownames()} and \code{colnames()}.
}
\examples{
fit <- lm(as.matrix(iris[1:2]) ~ Petal.Length + Petal.Width * Species, data = iris)
s <- hstats(fit, X = iris[3:5], verbose = FALSE)
x <- h2_pairwise(s)
dimnames(x)
rownames(x)
colnames(x)
}
