% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{lrt.hopit}
\alias{lrt.hopit}
\title{Likelihood ratio test for a pair of models}
\usage{
lrt.hopit(full, nested)
}
\arguments{
\item{full, nested}{models to be compared.}
}
\value{
a vector with the results of the test.
}
\description{
Likelihood ratio test for a pair of models
}
\examples{
\donttest{
# DATA
data(healthsurvey)

# the order of response levels decreases from the best health to
# the worst health; hence the hopit() parameter decreasing.levels
# is set to TRUE
levels(healthsurvey$health)

# Example 1 ---------------------

# fitting two nested models
model1 <- hopit(latent.formula = health ~ hypertension + high_cholesterol +
                heart_attack_or_stroke + poor_mobility + very_poor_grip +
                depression + respiratory_problems +
                IADL_problems + obese + diabetes + other_diseases,
              thresh.formula = ~ sex + ageclass + country,
              decreasing.levels = TRUE,
              control = list(trace = FALSE),
              data = healthsurvey)

# model with an interaction between hypertension and high_cholesterol
model2 <- hopit(latent.formula = health ~ hypertension * high_cholesterol +
                heart_attack_or_stroke + poor_mobility + very_poor_grip +
                depression + respiratory_problems +
                IADL_problems + obese + diabetes + other_diseases,
              thresh.formula = ~ sex + ageclass + country,
              decreasing.levels = TRUE,
              control = list(trace = FALSE),
              data = healthsurvey)

# Likelihood ratio test
lrt1 <- lrt.hopit(full = model2, nested = model1)
lrt1

# print the results in shorter form
print(lrt1, short = TRUE)

# equivalently
print(anova(model2, model1), short = TRUE)
}
}
\seealso{
\code{\link{print.lrt.hopit}}, \code{\link{anova.hopit}},
\code{\link{hopit}}.
}
\author{
Maciej J. Danko
}
\keyword{internal}
