% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_rstar_glm_pgsql.R
\name{sim_rstar_glm_pgsql}
\alias{sim_rstar_glm_pgsql}
\title{Shiny App for Running r* GLM Simulations with PostgreSQL Integration}
\usage{
sim_rstar_glm_pgsql(dbname, datatable, host, port, user, password)
}
\arguments{
\item{dbname}{The name of the PostgreSQL database.}

\item{datatable}{The name of the table in the PostgreSQL database to save the results.}

\item{host}{The host of the PostgreSQL database.}

\item{port}{The port of the PostgreSQL database.}

\item{user}{The username for accessing the PostgreSQL database.}

\item{password}{The password for accessing the PostgreSQL database.}
}
\value{
A Shiny app object that can be run locally.
}
\description{
This function launches a Shiny application for setting up and running simulations
based on the \code{rstar_glm} function. The app allows users to input parameters for the
simulation, run the simulation, view results, and save results to a PostgreSQL database.
}
\examples{
if (interactive()) {
  sim_rstar_glm_pgsql(
    dbname = "mydb",
    datatable = "simulation_results",
    host = "localhost",
    port = 5432,
    user = "myuser",
    password = "mypassword"
  )
}

}
\references{
Pierce, D. A., & Bellio, R. (2017). Modern Likelihood-Frequentist Inference.
International Statistical Review / Revue Internationale de Statistique, 85(3),
519–541. \url{doi:10.1111/insr.12232}

Bellio R, Pierce D (2020). likelihoodAsy: Functions for Likelihood Asymptotics.
R package version 0.51, \url{https://CRAN.R-project.org/package=likelihoodAsy}.
}
