% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learnModel.R
\name{learnModel}
\alias{learnModel}
\title{Learna a HMM-A from data}
\usage{
learnModel(
  data,
  amountOfStates = 2,
  maxit = 50,
  seed,
  iss = 1e-04,
  debug = FALSE
)
}
\arguments{
\item{data}{The datafile. The datafile should be a list containing a
dataframe with the data as its $x component and contain the lengths of the
observations a the $N component (see details).}

\item{amountOfStates}{The amount of states.}

\item{maxit}{The maximum amount of iterations.}

\item{seed}{Seed (optional).}

\item{iss}{The Imaginary Sample Size (iss), also called priors, to add data.}

\item{debug}{Debugmode.}
}
\value{
The output of the function is an asymmetric hidden Markov model. This
  model contains the amount of states, the initial distribution, the
  transition distribution and the emission distribution (Bayesian networks in
  the different states).

  The model can quicly be visualised with the \code{\link{visualise}} method.
  The \code{\link{visualise}} method does not show the Bayesian networks
  within the states as this would result in unreadable graphs. Instead, the
  \code{bnlearn} \code{\link[bnlearn]{graphviz.plot}} method can be used (see
  the examples below).
}
\description{
The \code{learnModel} function, learns a HMM-A from the supplied data file.
The function first creates a random model: the initial and transition
distributions are initialized using a Dirichlet
\url{https://en.wikipedia.org/wiki/Dirichlet_distribution} distribution.
Thereafter the model is maximised for the datafile that is supplied.
}
\details{
The \code{learnModel} makes use of the \code{mhsmm}
\code{\link[mhsmm]{hmmfit}} function. An example of the structure of the
datafile can be found in \code{\link{hmmaExampleData}}.
}
\examples{
fit <- learnModel(data = hmmaExampleData, amountOfStates = 3, seed = 1234)
visualise(fit)

# See bn in first state
library(bnlearn)
graphviz.plot(fit$parms.emission[[1]])

}
