% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_imp_cat_single.R
\name{imp_cat_single}
\alias{imp_cat_single}
\title{The function to impute unordered categorical variables}
\usage{
imp_cat_single(y_imp, X_imp, pvalue = 0.2, k = Inf)
}
\arguments{
\item{y_imp}{A Vector with the variable to impute.}

\item{X_imp}{A data.frame with the fixed effects variables.}

\item{pvalue}{A numeric between 0 and 1 denoting the threshold of p-values a variable in the imputation
model should not exceed. If they do, they are excluded from the imputation model.}

\item{k}{An integer defining the allowed maximum of levels in a factor covariate.}
}
\value{
A n x 1 data.frame with the original and imputed values.
}
\description{
The function uses regression trees for imputation implemented in \code{mice}.
The principle is the following:
For each observation it is calculated at which leave it would end.
Then one (randomly selected) observation of the other observations found on this leave
functions as a donor.
}
