% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{space_removal}
\alias{space_removal}
\title{Percentage of Space Removed}
\usage{
space_removal(
  ems,
  targets,
  points = NULL,
  ppd = NULL,
  cutoff = 3,
  individual = TRUE
)
}
\arguments{
\item{ems}{The emulators to compute over, as a list}

\item{targets}{The output target values}

\item{points}{The points to test against}

\item{ppd}{If no points are provided and uniform grid is wanted, the number of
points per parameter dimension.}

\item{cutoff}{The cutoff value for implausibility}

\item{individual}{If true, gives emulator-by-emulator results; otherwise works with maximum implausibility}
}
\value{
A numeric corresponding to the proportions of points removed.
}
\description{
For a wave of emulators, estimates the proportion of space removed at this wave.
}
\details{
Given a collection of emulators corresponding to a wave, we can look at an estimate of
the proportion of points from previous waves that will be accepted at this wave, either
on an emulator-by-emulator basis (to see which outputs are most restrictive) or as an all-wave
determination.

Naturally, such a statement will be an estimate of the restriction on the full space (which will
become more unreliable for higher dimensions), but it can give an order-of-magnitude statement,
or useful comparators between different emulators in a wave.

If no points are provided, the training points for the emulators are used. For best results, a
good number of points should be given: typically one should consider using as many points as one
knows to be in the NROY space (including any validation points, if accessible).
}
\examples{
 space_removal(SIREmulators$ems, SIREmulators$targets,
  rbind(SIRSample$training, SIRSample$validation))
 space_removal(SIREmulators$ems, SIREmulators$targets,
  rbind(SIRSample$training, SIRSample$validation), individual = FALSE)
}
\seealso{
\code{\link{space_removed}} for a visualisation of the space removal.
}
