% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma_div.R
\name{gamma_div}
\alias{gamma_div}
\title{Gamma diversity}
\usage{
gamma_div(countable,qvalue,tree,weight)
}
\arguments{
\item{countable}{A count table (matrix/data.frame) indicating the absolute or relative OTU/ASV abundances of multiple samples. Columns must refer to samples and rows to OTUs/ASVs.}

\item{qvalue}{A positive number, usually between 0 and 5, but most commonly 0, 1 or 2. It can be an integer or contain decimals.}

\item{tree}{A phylogenetic tree of class 'phylo'. The tip labels must match the row names in the count table. Use the function match_data() if the count table and tree names do not match.}

\item{weight}{A vector indicating the relative weight of each sample. The order needs to be identical to the order of the samples in the OTU table. The values need to sum up to 1. If empty, all samples are weighed the same.}
}
\value{
A gamma diversity value.
}
\description{
Compute gamma diversity of a system from a matrix (OTU table) containing multiple samples. If a tree is provided, the computed gamma diversity accounts for the phylogenetic relations across OTUs.
}
\details{
Gamma diversity computation (based on Hill numbers)
}
\examples{
data(bat.diet.otutable)
data(bat.diet.tree)
data(bat.diet.hierarchy)
gamma_div(countable=bat.diet.otutable,qvalue=1)
gamma_div(countable=bat.diet.otutable,qvalue=1,tree=bat.diet.tree)
weight.vector = rep(1/ncol(bat.diet.otutable),ncol(bat.diet.otutable))
gamma_div(bat.diet.otutable,1,bat.diet.tree,weight.vector)
}
\references{
Alberdi, A., Gilbert, M.T.P. (2019). A guide to the application of Hill numbers to DNA-based diversity analyses. Molecular Ecology Resources, 19, 804-817.\cr\cr
Chao, A., Chiu, C.H., & Hsieh, T. C. (2012). Proposing a resolution to debates on diversity partitioning. Ecology, 93, 2037-2051.\cr\cr
Jost, L. (2007). Partitioning diversity into independent alpha and beta components. Ecology, 88, 2427-2439.
}
\seealso{
\code{\link{div_part}}, \code{\link{alpha_div}}, \code{\link{match_data}}
}
\author{
Antton Alberdi, \email{anttonalberdi@gmail.com}
}
\keyword{gamma}
\keyword{hill}
\keyword{partitioning}
