% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHandling.R
\name{tradesCleanup}
\alias{tradesCleanup}
\title{Cleans trade data}
\usage{
tradesCleanup(
  dataSource = NULL,
  dataDestination = NULL,
  exchanges = "auto",
  tDataRaw = NULL,
  report = TRUE,
  selection = "median",
  validConds = c("", "@", "E", "@E", "F", "FI", "@F", "@FI", "I", "@I"),
  marketOpen = "09:30:00",
  marketClose = "16:00:00",
  printExchange = TRUE,
  saveAsXTS = FALSE,
  tz = NULL
)
}
\arguments{
\item{dataSource}{character indicating the folder in which the original data is stored.}

\item{dataDestination}{character indicating the folder in which the cleaned data is stored.}

\item{exchanges}{vector of stock exchange symbols for all data in \code{dataSource}, 
e.g. \code{exchanges = c("T","N")} retrieves all stock market data from both NYSE and NASDAQ.
The possible exchange symbols are:
\itemize{
\item A: AMEX
\item N: NYSE
\item B: Boston
\item P: Arca
\item C: NSX
\item T/Q: NASDAQ
\item D: NASD ADF and TRF
\item X: Philadelphia
\item I: ISE
\item M: Chicago
\item W: CBOE
\item Z: BATS
} The default value is \code{"auto"} which automatically selects the exchange for the stocks and days independently using the \code{\link{autoSelectExchangeTrades}}}

\item{tDataRaw}{\code{xts} object containing raw trade data. This argument is \code{NULL} by default. Enabling it means the arguments
\code{from}, \code{to}, \code{dataSource} and \code{dataDestination} will be ignored (only advisable for small chunks of data).}

\item{report}{boolean and \code{TRUE} by default. In case it is true the function returns (also) a vector indicating how many trades remained after each cleaning step.}

\item{selection}{argument to be passed on to the cleaning routine \code{\link{mergeTradesSameTimestamp}}. The default is "median".}

\item{validConds}{character vector containing valid sales conditions. Passed through to \code{\link{tradesCondition}}.}

\item{marketOpen}{character in the format of \code{"HH:MM:SS"},
specifying the opening time of the exchange(s).}

\item{marketClose}{character in the format of \code{"HH:MM:SS"},
specifying the closing time of the exchange(s).}

\item{printExchange}{Argument passed to \code{\link{autoSelectExchangeTrades}} indicates whether the chosen exchange is printed on the console, 
default is TRUE. This is only used when \code{exchanges} is \code{"auto"}}

\item{saveAsXTS}{indicates whether data should be saved in \code{xts} format instead of \code{data.table} when using on-disk functionality. FALSE by default.}

\item{tz}{fallback time zone used in case we we are unable to identify the timezone of the data, by default: \code{tz = NULL}. 
With the non-disk functionality, we attempt to extract the timezone from the DT column (or index) of the data, which may fail. 
In case of failure we use \code{tz} if specified, and if it is not specified, we use \code{"UTC"}. 
In the on-disk functionality, if \code{tz} is not specified, the timezone used will be the system default.}
}
\value{
For each day an \code{xts} or \code{data.table} object is saved into the folder of that date, containing the cleaned data.
This procedure is performed for each stock in \code{"ticker"}.
The function returns a vector indicating how many trades remained after each cleaning step.

In case you supply the argument \code{rawtData}, the on-disk functionality is ignored
and the function returns a list with the cleaned trades as \code{xts} object (see examples).
}
\description{
This is a wrapper function for cleaning the trade data of all stock data inside the folder dataSource. 
The result is saved in the folder dataDestination. 

In case you supply the argument \code{rawtData}, the on-disk functionality is ignored. The function returns a vector
indicating how many trades were removed at each cleaning step in this case.
and the function returns an \code{xts} or \code{data.table} object.

The following cleaning functions are performed sequentially:
\code{\link{noZeroPrices}}, \code{\link{autoSelectExchangeTrades}} or \code{\link{selectExchange}}, \code{\link{tradesCondition}}, and
\code{\link{mergeTradesSameTimestamp}}.

Since the function \code{\link{rmTradeOutliersUsingQuotes}}
also requires cleaned quote data as input, it is not incorporated here and
there is a separate wrapper called \code{\link{tradesCleanupUsingQuotes}}.
}
\details{
Using the on-disk functionality with .csv.zip files from the WRDS database
will write temporary files on your machine in order to unzip the files - we try to clean up after it,
but cannot guarantee that there won't be files that slip through the crack if the permission settings on your machine does not match 
ours.

If the input \code{data.table} does not contain a DT column but it does contain DATE and TIME_M columns, we create the DT column by REFERENCE, altering the \code{data.table} that may be in the user's environment.
}
\examples{
# Consider you have raw trade data for 1 stock for 2 days 
head(sampleTDataRaw)
dim(sampleTDataRaw)
tDataAfterFirstCleaning <- tradesCleanup(tDataRaw = sampleTDataRaw, 
                                         exchanges = list("N"))
tDataAfterFirstCleaning$report
dim(tDataAfterFirstCleaning$tData)
# In case you have more data it is advised to use the on-disk functionality
# via "dataSource" and "dataDestination" arguments

}
\references{
Barndorff-Nielsen, O. E., Hansen, P. R., Lunde, A., and Shephard, N. (2009). Realized kernels in practice: Trades and quotes. \emph{Econometrics Journal}, 12, C1-C32.

Brownlees, C.T. and Gallo, G.M. (2006). Financial econometric analysis at ultra-high frequency: Data handling concerns. \emph{Computational Statistics & Data Analysis}, 51, 2232-2245.
}
\author{
Jonathan Cornelissen, Kris Boudt, Onno Kleen, and Emil Sjoerup
}
\keyword{cleaning}
