\name{rThresholdCov}
\Rdversion{1.1}
\alias{rThresholdCov}
\title{Threshold Covariance}

\description{
Function returns the treshold covariance matrix proposed in Gobbi and Mancini (2009).
 Unlike the \code{\link{rOWCov}}, the THRESCov uses univariate jump detection rules to truncate the effect of jumps on the covariance
estimate. As such, it remains feasible in high dimensions, but it is less robust to small cojumps. 

Let \eqn{r_{t,i}} be an intraday \eqn{N x 1} return vector and \eqn{i=1,...,M}
the number of intraday returns.

Then, the \eqn{k,q}-th element of the threshold covariance matrix is defined as
\deqn{
\mbox{tresholdcov}[k,q]_{t} = \sum_{i=1}^{M} r_{(k)t,i} 1_{\{r_{(k)t,i}^2 \leq TR_{M}\}}  \ \ r_{(q)t,i} 1_{\{r_{(q)t,i}^2 \leq TR_{M}\}},
}
with the treshold value \eqn{TR_{M}} set to \eqn{9 \Delta^{-1}} times the daily realized bi-power variation of asset \eqn{k}, 
as suggested in Jacod and Todorov (2009).
}

\usage{
rThresholdCov(rdata, cor = FALSE, align.by = NULL, align.period = NULL, 
               makeReturns = FALSE, ...)
} 

\arguments{ 
  \item{rdata}{ a \eqn{(M x N)} matrix/zoo/xts object containing the \eqn{N}
return series over period \eqn{t}, with \eqn{M} observations during \eqn{t}.}
  \item{cor}{boolean, in case it is TRUE, the correlation is returned. FALSE by default.}
  \item{align.by}{a string, align the tick data to "seconds"|"minutes"|"hours".}
  \item{align.period}{an integer, align the tick data to this many [seconds|minutes|hours].}  
  \item{makeReturns}{boolean, should be TRUE when rdata contains prices instead of returns. FALSE by default.}
  \item{...}{additional arguments.}
} 

\value{
an \eqn{N x N} matrix
} 

\references{ 
Barndorff-Nielsen, O. and N. Shephard (2004). Measuring the impact of
jumps in multivariate price processes using bipower covariation. Discussion
paper, Nuffield College, Oxford University.

Jacod, J. and V. Todorov (2009). Testing for common arrival of jumps in
discretely-observed multidimensional processes. Annals of Statistics 37,
1792-1838.

Mancini, C. and F. Gobbi (2009). Identifying the covariation between the diffusion
parts and the co-jumps given discrete observations. Mimeo.
} 

\author{ Jonathan Cornelissen and Kris Boudt}

\examples{
 # Realized threshold  Variance/Covariance: 
 data(lltc.xts); 
 data(sbux.xts); 
 
 # Multivariate:
 rcThreshold = rThresholdCov(cbind(lltc.xts,sbux.xts), align.by="minutes",align.period=1); 
 rcThreshold  
} 

\keyword{volatility}
