% Generated by roxygen2 (4.0.2): do not edit by hand
\name{estimate.fdr}
\alias{estimate.fdr}
\title{Estimate FDR}
\usage{
estimate.fdr(x, y, lamlist, type = c("Fisher", "simple"), B = 100)
}
\arguments{
\item{x}{n by p design matrix}

\item{y}{binary (0 or 1) vector of length n indicating class}

\item{lamlist}{a vector of cutoffs for the statistics}

\item{type}{determines whether Fisher transform should be applied to
interaction contrasts.  Default: Fisher. See \link{hiertest} for more
information.}

\item{B}{number of permutations}
}
\value{
A \code{estfdr} object, which consists of \describe{
  \item{\code{ncalled}:}{number of interactions called significant at each
  cutoff. Set to NA if 0.} \item{\code{null.ncalled}:}{total number, across
  all permutations, of (null) interactions rejected at each cutoff}
  \item{\code{fdr}:}{estimate of fdr for each cutoff in lamlist. Set to NA if
  no interactions are rejected at this cutoff} }
}
\description{
Estimates False Discovery Rate (FDR) based on permutation scheme described in
CHT paper (reference below).
}
\examples{
# generate some data accoring to the backward model:
set.seed(1)
n <- 200
p <- 50
y <- rep(0:1, each=n/2)
x <- matrix(rnorm(n*p), n, p)
colnames(x) <- c(letters,LETTERS)[1:p]
# make some interactions between several pairs of variables:
R <- matrix(0.3, 5, 5)
diag(R) <- 1
x[y==1, 1:5] <- x[y==1, 1:5] \%*\% R
# and a main effect for variables 1 and 3:
x[y==1, 1:5] <- x[y==1, 1:5] + 0.5
testobj <- hiertest(x=x, y=y, type="Fisher")
# look at test statistics
print(testobj)
plot(testobj)
\dontrun{
lamlist <- seq(5, 2, length=100)
estfdr <- estimate.fdr(x, y, lamlist, type="Fisher", B=200)
plot(estfdr)
print(estfdr)
# the cutoff lamlist[70] is estimated to have roughly 10\% FDR:
estfdr$fdr[70]
# this allows us to reject this many interactions:
nrejected <- estfdr$ncalled[70]
# These are the interactions rejected:
interactions.above(testobj, lamlist[70])
}
}
\references{
Bien, Simon, and Tibshirani (2015) Convex Hierarchical Testing
of Interactions. Annals of Applied Statistics. Vol. 9, No. 1, 27-42.
}
\seealso{
\code{\link{hiertest}}
}

