% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_dosage.R
\name{matching}
\alias{matching}
\title{Estimates matching between pairs of individuals}
\usage{
matching(dos)
}
\arguments{
\item{dos}{A matrix of 0, 1 and 2s with loci (SNPs) in columns and individuals in rows. 
missing values are allowed}
}
\value{
a matrix of pairwise matching
}
\description{
Estimates matching between pairs of individuals (for each locus, gives 1 if the two individuals are homozygous
for the same allele, 0 if they are homozygous for a different allele, and 1/2 if at least one individual 
is heterozygous. Matching is the average of these 0, 1/2 and 1s)
}
\details{
This function is written for dosage data, i.e., how many doses of an allele (0, 1 or 2) an individual carries.
It should be use for bi-allelic markers only (e.g. SNPs), although you might "force" a k multiallelic locus to k 
biallelic loci (see \code{\link{fstat2dos}}).
}
