% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rect_adj_RW2}
\alias{rect_adj_RW2}
\title{Produce an RW2 Adjacency matrix for a rectangular grid for use with areal spatial models.
This formulation uses cofficients inspired by a thin plate spline, as described in Rue & Held, section 3.4.2
Here I'm outputting an adjacency matrix of 'neighbor weights' which makes Q construction for regular latices
easy to do when not trying to make inference about all cells (i.e., one can just
eliminate rows and columns associated with cells one isn't interested in and set Q=-Adj+Diag(sum(Adj))}
\usage{
rect_adj_RW2(x, y, byrow = FALSE)
}
\arguments{
\item{x}{number of cells on horizontal side of grid}

\item{y}{number of cells on vertical side of grid}

\item{byrow}{If TRUE, cell indices are filled along rows (default is FALSE)}
}
\value{
adjacency matrix
}
\description{
Produce an RW2 Adjacency matrix for a rectangular grid for use with areal spatial models.
This formulation uses cofficients inspired by a thin plate spline, as described in Rue & Held, section 3.4.2
Here I'm outputting an adjacency matrix of 'neighbor weights' which makes Q construction for regular latices
easy to do when not trying to make inference about all cells (i.e., one can just
eliminate rows and columns associated with cells one isn't interested in and set Q=-Adj+Diag(sum(Adj))
}
\author{
Paul Conn \email{paul.conn@noaa.gov}
}
\keyword{adjacency}

