% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performTest.R
\name{performTest}
\alias{performTest}
\alias{print.resdiff}
\alias{summary.resdiff}
\alias{plot.resdiff}
\title{Perform diffHic Test}
\usage{
performTest(
  matrices,
  cond,
  outFile = NULL,
  filterLc = FALSE,
  filterFlank = FALSE,
  flank = NULL
)

\method{print}{resdiff}(x, ...)

\method{summary}{resdiff}(object, ...)

\method{plot}{resdiff}(x, whichPlot = c("p.value", "p.adj", "logFC"), ...)
}
\arguments{
\item{matrices}{an object of class
\code{\link[InteractionSet:interactions]{InteractionSet}} obtained from the
function \code{\link{loadData}}. Conditions correspond to the columns (one
column per replicate).}

\item{cond}{a vector indicating the condition of each column of
\code{matrices}.}

\item{outFile}{path to export outputs of the function, set to \code{NULL} by
default, in which case results are not exported.}

\item{filterLc}{logical. Whether to filter out low counts or not. Set to
\code{FALSE} by default, in which case no filtering is performed. See
\code{\link[diffHic:filterTrended]{filterTrended}} for more details.}

\item{filterFlank}{logical. Whether to filter out on enriched pairs. Set to
\code{FALSE} by default, in which case no filtering is performed. See
\code{\link[diffHic:enrichedPairs]{enrichedPairs}} and
\code{\link[diffHic:filterPeaks]{filterPeaks}} for more details.}

\item{flank}{flank parameter used only if \code{filterFlank = TRUE}. Set to
\code{NULL} by default. See
\code{\link[diffHic:enrichedPairs]{enrichedPairs}} for more details.}

\item{x}{a \code{resdiff} object to plot}

\item{...}{not used}

\item{object}{a \code{resdiff} object to print}

\item{whichPlot}{a character string indicating which plot to display.
Possible values are \code{"p.value"}, \code{"p.adj"} and \code{"logFC"}. Set
to \code{"p.value"} by default.}
}
\value{
An object of class \code{resdiff} with the following entries:
\item{region1}{the first bin of the interaction}
\item{region2}{the second bin of the interaction}
\item{p.value}{the p-value of the \code{\link[diffHic]{diffHic}} test}
\item{p.adj}{the adjusted p-value of the \code{\link[diffHic]{diffHic}} test}
\item{logFC}{the log2-fold-change of the interaction}
}
\description{
This function performs diffHic differential analysis for every
 pixel of the matrix.
}
\examples{
data("pighic")
resdiff <- performTest(pighic$data, pighic$conditions)
resdiff
summary(resdiff)
plot(resdiff)
plot(resdiff, whichPlot = "p.adj")
plot(resdiff, whichPlot = "logFC")

}
\author{
Élise Jorge \email{elise.jorge@inrae.fr}\cr
Sylvain Foissac \email{sylvain.foissac@inrae.fr}\cr
Toby Dylan Hocking \email{toby.hocking@r-project.org}\cr
Pierre Neuvial \email{pierre.neuvial@math.univ-toulouse.fr}\cr
Nathalie Vialaneix \email{nathalie.vialaneix@inrae.fr}
}
