% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train-test-split.R
\name{train_test_split}
\alias{train_test_split}
\title{Splitting the data sets to train and test}
\usage{
train_test_split(train, train.ratio = 0.7, trim = FALSE)
}
\arguments{
\item{train}{the train data of class \code{"hhsmmdata"}}

\item{train.ratio}{a number in (0,1) which determines the ratio of the train subset}

\item{trim}{logical. if TRUE the sequences will be right trimmed with random lengths}
}
\value{
a list containing:
\itemize{
\item\code{train}{ the randomly selected subset of train data of class \code{"hhsmmdata"}}
\item\code{test}{ the randomly selected subset of test data of class \code{"hhsmmdata"}. 
If \code{trim}=TRUE, the test list also contains the RUL (residual useful lifetime) values}
}
}
\description{
A function to split the train data of class \code{"hhsmmdata"}
to train and test subsets with an option to right trim the sequences
}
\details{
In reliability applications, the hhsmm models are often left-to-right
and the modeling aims to predict the future states. In such cases, the
test sets are right trimmed and the prediction aims to predict the
residual useful lifetime (RUL) of a new sequence.
}
\examples{
\donttest{
data(CMAPSS)
tt = train_test_split(CMAPSS$train,train.ratio = 0.7, trim = TRUE)
}

}
\author{
Morteza Amini, \email{morteza.amini@ut.ac.ir}, Afarin Bayat, \email{aftbayat@gmail.com}
}
