% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-loading.R
\name{analyze_package_imports}
\alias{analyze_package_imports}
\title{Analyze package imports}
\usage{
analyze_package_imports(files = list.files(pattern = "\\\\.[rR]$",
  recursive = TRUE))
}
\arguments{
\item{files}{A vector of filenames of R source files. Typically this is created by \code{list.files(folder, pattern="\\\.[rR]$")}}
}
\value{
a named list of results (invisibly). This list contains all import statements, a list of duplicated imports,
a list of redundant imports, all function calls in the files with the corresponding imports and a list of packages with the number of function calls.
}
\description{
Analyzes the package imports via \code{library()} and \code{load_packages()} in a list of filenames.
}
\examples{
\dontrun{
analyze_package_imports(list.files(pattern="\\\\.[rR]$", recursive=TRUE))
}
}
