% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_conversions.R
\name{hexify_lonlat_to_plane}
\alias{hexify_lonlat_to_plane}
\title{Convert longitude/latitude to PLANE coordinates}
\usage{
hexify_lonlat_to_plane(lon, lat)
}
\arguments{
\item{lon}{Longitude in degrees (-180 to 180)}

\item{lat}{Latitude in degrees (-90 to 90)}
}
\value{
Data frame with columns:
\item{plane_x}{X coordinate in PLANE space (range ~0 to 5.5)}
\item{plane_y}{Y coordinate in PLANE space (range ~0 to 1.73)}
}
\description{
Converts geographic coordinates directly to PLANE coordinates
(unfolded icosahedron). Combines forward 'Snyder' projection with
the PLANE transformation.
}
\details{
Equivalent to 'dggridR' dgGEO_to_PLANE().
}
\examples{
# Plot world cities in PLANE coordinates
cities <- data.frame(
  lon = c(2.35, -74.00, 139.69, 151.21),
  lat = c(48.86, 40.71, 35.69, -33.87)
)
plane <- hexify_lonlat_to_plane(cities$lon, cities$lat)
plot(plane$plane_x, plane$plane_y)
}
\seealso{
\code{\link{hexify_cell_to_plane}} for cell ID conversion,
\code{\link{hexify_icosa_tri_to_plane}} for triangle conversion

Other coordinate conversion: 
\code{\link{hexify_cell_id_to_quad_ij}()},
\code{\link{hexify_cell_to_icosa_tri}()},
\code{\link{hexify_cell_to_lonlat}()},
\code{\link{hexify_cell_to_plane}()},
\code{\link{hexify_cell_to_quad_ij}()},
\code{\link{hexify_cell_to_quad_xy}()},
\code{\link{hexify_grid_cell_to_lonlat}()},
\code{\link{hexify_grid_to_cell}()},
\code{\link{hexify_icosa_tri_to_plane}()},
\code{\link{hexify_icosa_tri_to_quad_ij}()},
\code{\link{hexify_icosa_tri_to_quad_xy}()},
\code{\link{hexify_lonlat_to_cell}()},
\code{\link{hexify_lonlat_to_quad_ij}()},
\code{\link{hexify_quad_ij_to_cell}()},
\code{\link{hexify_quad_ij_to_icosa_tri}()},
\code{\link{hexify_quad_ij_to_xy}()},
\code{\link{hexify_quad_xy_to_cell}()},
\code{\link{hexify_quad_xy_to_icosa_tri}()},
\code{\link{hexify_roundtrip_test}()}
}
\concept{coordinate conversion}
\keyword{internal}
