% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heuristics.R
\name{unitWeightModel}
\alias{unitWeightModel}
\title{Unit-weight linear model}
\usage{
unitWeightModel(train_data, criterion_col, cols_to_fit,
  reverse_cues = TRUE, fit_name = "unitWeightModel")
}
\arguments{
\item{train_data}{Training/fitting data as a matrix or data.frame.}

\item{criterion_col}{The index of the colum in train_data that has the
criterion.}

\item{cols_to_fit}{A vector of column indices in train_data, used to fit
the criterion.}

\item{reverse_cues}{Optional parameter to reverse cues as needed.}

\item{fit_name}{Optional The name other functions can use to label output.
It defaults to the class name.}
}
\value{
An object of \code{\link[base]{class}} unitWeightModel.  This is a list
containing at least the following components:
  \itemize{
   \item "cue_validities": A list of cue validities for the cues in order of
     cols_to_fit.
   \item "linear_coef": A list of linear model coefficents (-1 or +1)
          for the cues in order of cols_to_fit.  (It can only return -1's if
          reverse_cues=TRUE.)
  }
}
\description{
Unit-weight linear model inspired by Robyn Dawes.
Unit Weight Model assigns unit (+1 or -1) weights based on
\code{\link{cueValidity}}.
  \itemize{
    \item A cue validity > 0.5 results in a weight of +1.
    \item A cue validity < 0.5 results in a weight of -1.
  }
This version differs from others in that it uses a weight of 0 if cue
validity is 0.5 (rather than randomly assigning +1 or -1) to give faster
convergence of average accuracy.
}
\references{
Wikipedia's entry on
\url{http://en.wikipedia.org/wiki/Unit-weighted_regression}.
}
\seealso{
\code{\link{cueValidity}} for the metric used to to determine cue direction.

\code{\link{predictPair}} for predicting whether row1 is greater.

\code{\link{predictPairProb}} for predicting the probability row1 is
greater.
}
