% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetu_diagnostic.R
\name{hetu_diagnostic}
\alias{hetu_diagnostic}
\alias{pin_diagnostic}
\title{Diagnostics Tool for HETU}
\usage{
hetu_diagnostic(pin, extract = NULL, subsetting = FALSE)

pin_diagnostic(pin, extract = NULL, subsetting = FALSE)
}
\arguments{
\item{pin}{Finnish personal identification number as a character vector, 
or vector of identification numbers as a character vectors}

\item{extract}{Extract only selected part of the diagnostic information.
 Valid values are "\code{hetu}", "\code{is.temp}", "\code{valid.p.num}",
 "\code{valid.checksum}", "\code{correct.checksum}", "\code{valid.date}",
 "\code{valid.day}", "\code{valid.month}", "\code{valid.length}", 
"\code{valid.century}". If \code{NULL} (default), returns all information.}

\item{subsetting}{Print only PINs where the validity check chosen in \code{extract} returns \code{FALSE}.}
}
\value{
A data.frame containing diagnostic checks about PINs.
}
\description{
Produce a data frame of PINs that may require closer scrutiny.
}
\examples{
diagnosis_example <- c("010101-0102", "111111-111Q", 
"010101B0101", "320101-0101", "011301-0101", 
"010101-01010", "010101-0011")
## Print all diagnoses
hetu_diagnostic(diagnosis_example)
# Extract century-related checks
hetu_diagnostic(diagnosis_example, extract = "valid.century")
# Extract only rows where invalid.checksum = TRUE
hetu_diagnostic(diagnosis_example, subsetting = TRUE, extract = "valid.checksum") 

diagnosis_example <- c("010101-0102", "111111-111Q", 
"010101B0101", "320101-0101", "011301-0101", 
"010101-01010", "010101-0011")
## Print all diagnoses
pin_diagnostic(diagnosis_example)
}
