% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetGP.R
\name{predict.homGP}
\alias{predict.homGP}
\title{Gaussian process predictions using a homoskedastic noise GP object (of class \code{homGP})}
\usage{
\method{predict}{homGP}(object, x, xprime = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{homGP}; e.g., as returned by \code{\link[hetGP]{mleHomGP}}}

\item{x}{matrix of designs locations to predict at (one point per row)}

\item{xprime}{optional second matrix of predictive locations to obtain the predictive covariance matrix between \code{x} and \code{xprime}}

\item{...}{no other argument for this method}
}
\value{
list with elements
\itemize{
\item \code{mean}: kriging mean;
\item \code{sd2}: kriging variance (filtered, e.g. without the nugget value)
\item \code{cov}: predictive covariance matrix between \code{x} and \code{xprime}
\item \code{nugs}: nugget value at each prediction location, for consistency with \code{\link[hetGP]{mleHomGP}}.
}
}
\description{
Gaussian process predictions using a homoskedastic noise GP object (of class \code{homGP})
}
\details{
The full predictive variance corresponds to the sum of \code{sd2} and \code{nugs}. See \code{\link[hetGP]{mleHomGP}} for examples.
}
