% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_def.R
\name{define_rng}
\alias{define_rng}
\alias{eval_rng}
\title{Define and evaluate random number generation expressions}
\usage{
define_rng(expr, n = 1, ...)

eval_rng(x, params = NULL, check = TRUE)
}
\arguments{
\item{expr}{An expression used to randomly draw variates for each parameter of
interest in the model. \link[base:Paren]{Braces} should be used so that the result
of the last expression within the braces is evaluated. The expression must
return a list where each element is either a \code{vector} or tabular object
( \code{matrix}, \code{data.frame}, or \code{data.table}). The length of the vector must
either be or \code{n} and the number of rows in the tabular object must be \code{n}.}

\item{n}{Number of samples of the parameters to draw.}

\item{...}{Additional arguments to pass to the environment used to evaluate
\code{expr}.}

\item{x}{An object of class \code{rng_def} created with \code{define_rng()}.}

\item{params}{A list containing the values of parameters for random number
generation. Each element of the list should either be a \code{vector},
\code{matrix}, \code{data.frame}, or \code{data.table}}

\item{check}{Whether to check the returned output so that (i) it returns a list
and (ii) each element has the correct length or number of rows. Default is \code{TRUE},
meaning that any output can be returned. This is always \code{TRUE} when used inside
\code{\link[=define_model]{define_model()}}.}
}
\value{
\code{define_rng()} returns an object of class \code{rng_def},
which is a list containing the unevaluated random number generation
expressions passed  to \code{expr}, \code{n}, and any additional arguments passed to
\code{...} . \code{eval_rng()} evaluates the \code{rng_def} object and
returns an \code{eval_rng} object containing the evaluated expression.
}
\description{
Random number generation expressions are used to
randomly sample model parameters from suitable distributions for probabilistic
sensitivity analysis. These functions are typically used when evaluating
an object of class \code{model_def} defined using \code{\link[=define_model]{define_model()}}.
}
\details{
\code{hesim} contains a number of random number generation functions
that return parameter samples in convenient formats
and do not typically require the number of samples, \code{n}, as arguments
(see \code{\link{rng_distributions}}). The random number generation expressions
are evaluated using \code{eval_rng()} and used within \code{expr}
in \code{define_rng()}. If a multivariate object is returned by \code{eval_rng()},
then the rows are random samples and columns are
distinct parameters (e.g., costs for each health state, elements of a
transition probability matrix).
}
\examples{
 
params <- list(
  alpha = matrix(c(75, 25, 33, 67), byrow = TRUE, ncol = 2),
  inptcost_mean = c(A = 900, B = 1500, C = 2000),
  outptcost_mean = matrix(c(300, 600, 800,
                            400, 700, 700),
                           ncol = 3, byrow = TRUE)
)
rng_def <- define_rng({
  aecost_mean <- c(500, 800, 1000) # Local object not 
                                   # not returned by eval_rng()
  list( # Sampled values of parameters returned by eval_rng()
    p = dirichlet_rng(alpha), # Default column names
    inptcost = gamma_rng(mean = inptcost_mean, # Column names based on 
                         sd = inptcost_mean),  # named vector
    outptcost = outptcost_mean, # No column names because
                                # outptcost_mean has none.
    aecost = gamma_rng(mean = aecost_mean, # Explicit naming of columns
                       sd = aecost_mean,
                       names = aecost_colnames)
  )
}, n = 2, aecost_colnames = c("A", "B", "C")) # Add aecost_colnames to environment
params_sample <- eval_rng(x = rng_def, params)
summary(params_sample)
params_sample
}
\seealso{
Parameters can be conveniently sampled from probability distributions
using a number of random number generation functions (see \code{\link{rng_distributions}}).
An economic model can be created with \code{\link[=create_CohortDtstm]{create_CohortDtstm()}} by using
\code{define_rng()} (or a previously evaluated \code{eval_rng} object)
alongside \code{\link[=define_tparams]{define_tparams()}} to define a model with \code{\link[=define_model]{define_model()}}.
It can be useful to summarize an evaluated expression with \code{summary.eval_rng()}.
}
